// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Inhttp.pas' rev: 10.00

#ifndef InhttpHPP
#define InhttpHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Inexception.hpp>	// Pascal unit
#include <Inexceptioncore.hpp>	// Pascal unit
#include <Inassignednumbers.hpp>	// Pascal unit
#include <Inheaderlist.hpp>	// Pascal unit
#include <Inhttpheaderinfo.hpp>	// Pascal unit
#include <Inreplyrfc.hpp>	// Pascal unit
#include <Inssl.hpp>	// Pascal unit
#include <Inzlibcompressorbase.hpp>	// Pascal unit
#include <Intcpclient.hpp>	// Pascal unit
#include <Inuri.hpp>	// Pascal unit
#include <Incookie.hpp>	// Pascal unit
#include <Incookiemanager.hpp>	// Pascal unit
#include <Inauthentication.hpp>	// Pascal unit
#include <Inauthenticationmanager.hpp>	// Pascal unit
#include <Inmultipartformdata.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit
#include <Intcpconnection.hpp>	// Pascal unit
#include <Incomponent.hpp>	// Pascal unit
#include <Inbasecomponent.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Inhttp
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TInHTTPMethod { hmHead, hmGet, hmPost, hmOptions, hmTrace, hmPut, hmDelete, hmConnect };
#pragma option pop

#pragma option push -b-
enum TInHTTPWhatsNext { wnGoToURL, wnJustExit, wnDontKnow, wnReadAndGo, wnAuthRequest };
#pragma option pop

#pragma option push -b-
enum TInHTTPConnectionType { ctNormal, ctSSL, ctProxy, ctSSLProxy };
#pragma option pop

#pragma option push -b-
enum TInHTTPOption { hoInProcessAuth, hoKeepOrigProtocol, hoForceEncodeParams };
#pragma option pop

typedef Set<TInHTTPOption, hoInProcessAuth, hoForceEncodeParams>  TInHTTPOptions;

#pragma option push -b-
enum TInHTTPProtocolVersion { pv1_0, pv1_1 };
#pragma option pop

typedef void __fastcall (__closure *TInHTTPOnRedirectEvent)(System::TObject* Sender, AnsiString &dest, int &NumRedirect, bool &Handled, TInHTTPMethod &VMethod);

typedef void __fastcall (__closure *TIdOnSelectAuthorization)(System::TObject* Sender, TMetaClass* &AuthenticationClass, Inheaderlist::TInHeaderList* AuthInfo);

typedef void __fastcall (__closure *TIdOnAuthorization)(System::TObject* Sender, Inauthentication::TInAuthentication* Authentication, bool &Handled);

class DELPHICLASS TInHTTPResponse;
class DELPHICLASS TIdCustomHTTP;
class DELPHICLASS TInHTTPProtocol;
class DELPHICLASS TInHTTPRequest;
class PASCALIMPLEMENTATION TInHTTPRequest : public Inhttpheaderinfo::TIdRequestHeaderInfo 
{
	typedef Inhttpheaderinfo::TIdRequestHeaderInfo inherited;
	
protected:
	TIdCustomHTTP* FHTTP;
	AnsiString FURL;
	TInHTTPMethod FMethod;
	Classes::TStream* FSourceStream;
	TInHTTPConnectionType FUseProxy;
	Inglobal::TIdIPVersion FIPVersion;
	
public:
	__fastcall virtual TInHTTPRequest(TIdCustomHTTP* AHTTP);
	__property AnsiString URL = {read=FURL, write=FURL};
	__property TInHTTPMethod Method = {read=FMethod, write=FMethod, nodefault};
	__property Classes::TStream* Source = {read=FSourceStream, write=FSourceStream};
	__property TInHTTPConnectionType UseProxy = {read=FUseProxy, nodefault};
	__property Inglobal::TIdIPVersion IPVersion = {read=FIPVersion, write=FIPVersion, nodefault};
public:
	#pragma option push -w-inl
	/* TIdRequestHeaderInfo.Destroy */ inline __fastcall virtual ~TInHTTPRequest(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TInHTTPProtocol : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TIdCustomHTTP* FHTTP;
	int FResponseCode;
	TInHTTPRequest* FRequest;
	TInHTTPResponse* FResponse;
	__fastcall TInHTTPProtocol(TIdCustomHTTP* AConnection);
	__fastcall virtual ~TInHTTPProtocol(void);
	TInHTTPWhatsNext __fastcall ProcessResponse(short * AIgnoreReplies, const int AIgnoreReplies_Size);
	void __fastcall BuildAndSendRequest(Inuri::TInURI* AURI);
	void __fastcall RetrieveHeaders(int AMaxHeaderCount);
	__property int ResponseCode = {read=FResponseCode, nodefault};
	__property TInHTTPRequest* Request = {read=FRequest};
	__property TInHTTPResponse* Response = {read=FResponse};
};


class PASCALIMPLEMENTATION TIdCustomHTTP : public Intcpclient::TInTCPClientCustom 
{
	typedef Intcpclient::TInTCPClientCustom inherited;
	
protected:
	int FAuthRetries;
	int FAuthProxyRetries;
	Incookiemanager::TInCookieManager* FCookieManager;
	Inzlibcompressorbase::TInZLibCompressorBase* FCompressor;
	bool FFreeOnDestroy;
	int FMaxAuthRetries;
	int FMaxHeaderLines;
	bool FAllowCookies;
	Inauthenticationmanager::TInAuthenticationManager* FAuthenticationManager;
	TInHTTPProtocolVersion FProtocolVersion;
	int FRedirectCount;
	int FRedirectMax;
	bool FHandleRedirects;
	TInHTTPOptions FOptions;
	Inuri::TInURI* FURI;
	TInHTTPProtocol* FHTTPProto;
	Inhttpheaderinfo::TIdProxyConnectionInfo* FProxyParameters;
	TInHTTPOnRedirectEvent FOnRedirect;
	TIdOnSelectAuthorization FOnSelectAuthorization;
	TIdOnSelectAuthorization FOnSelectProxyAuthorization;
	TIdOnAuthorization FOnAuthorization;
	TIdOnAuthorization FOnProxyAuthorization;
	virtual void __fastcall DoRequest(const TInHTTPMethod AMethod, AnsiString AURL, Classes::TStream* ASource, Classes::TStream* AResponseContent, short * AIgnoreReplies, const int AIgnoreReplies_Size);
	virtual void __fastcall InitComponent(void);
	void __fastcall SetAuthenticationManager(Inauthenticationmanager::TInAuthenticationManager* Value);
	void __fastcall SetCookieManager(Incookiemanager::TInCookieManager* ACookieManager);
	void __fastcall SetAllowCookies(bool AValue);
	int __fastcall GetResponseCode(void);
	AnsiString __fastcall GetResponseText();
	virtual bool __fastcall DoOnAuthorization(TInHTTPRequest* ARequest, TInHTTPResponse* AResponse);
	virtual bool __fastcall DoOnProxyAuthorization(TInHTTPRequest* ARequest, TInHTTPResponse* AResponse);
	virtual bool __fastcall DoOnRedirect(AnsiString &Location, TInHTTPMethod &VMethod, int RedirectCount);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	void __fastcall ProcessCookies(TInHTTPRequest* ARequest, TInHTTPResponse* AResponse);
	TInHTTPConnectionType __fastcall SetHostAndPort(void);
	void __fastcall SetCookies(Inuri::TInURI* AURL, TInHTTPRequest* ARequest);
	void __fastcall ReadResult(TInHTTPResponse* AResponse);
	void __fastcall PrepareRequest(TInHTTPRequest* ARequest);
	void __fastcall ConnectToHost(TInHTTPRequest* ARequest, TInHTTPResponse* AResponse);
	TInHTTPResponse* __fastcall GetResponseHeaders(void);
	TInHTTPRequest* __fastcall GetRequestHeaders(void);
	void __fastcall SetRequestHeaders(TInHTTPRequest* Value);
	void __fastcall EncodeRequestParams(Classes::TStrings* AStrings);
	AnsiString __fastcall SetRequestParams(Classes::TStrings* AStrings);
	void __fastcall CheckAndConnect(TInHTTPResponse* AResponse);
	virtual void __fastcall DoOnDisconnected(void);
	
public:
	__fastcall virtual ~TIdCustomHTTP(void);
	void __fastcall Options(AnsiString AURL)/* overload */;
	void __fastcall Get(AnsiString AURL, Classes::TStream* AResponseContent)/* overload */;
	void __fastcall Get(AnsiString AURL, Classes::TStream* AResponseContent, short * AIgnoreReplies, const int AIgnoreReplies_Size)/* overload */;
	AnsiString __fastcall Get(AnsiString AURL)/* overload */;
	AnsiString __fastcall Get(AnsiString AURL, short * AIgnoreReplies, const int AIgnoreReplies_Size)/* overload */;
	void __fastcall Trace(AnsiString AURL, Classes::TStream* AResponseContent)/* overload */;
	AnsiString __fastcall Trace(AnsiString AURL)/* overload */;
	void __fastcall Head(AnsiString AURL);
	AnsiString __fastcall Post(AnsiString AURL, Classes::TStrings* ASource)/* overload */;
	AnsiString __fastcall Post(AnsiString AURL, Classes::TStream* ASource)/* overload */;
	AnsiString __fastcall Post(AnsiString AURL, Inmultipartformdata::TInMultipartFormDataStream* ASource)/* overload */;
	void __fastcall Post(AnsiString AURL, Inmultipartformdata::TInMultipartFormDataStream* ASource, Classes::TStream* AResponseContent)/* overload */;
	void __fastcall Post(AnsiString AURL, Classes::TStrings* ASource, Classes::TStream* AResponseContent)/* overload */;
	void __fastcall Post(AnsiString AURL, Classes::TStream* ASource, Classes::TStream* AResponseContent)/* overload */;
	AnsiString __fastcall Put(AnsiString AURL, Classes::TStream* ASource)/* overload */;
	void __fastcall Put(AnsiString AURL, Classes::TStream* ASource, Classes::TStream* AResponseContent)/* overload */;
	__property Inzlibcompressorbase::TInZLibCompressorBase* Compressor = {read=FCompressor, write=FCompressor};
	__property int ResponseCode = {read=GetResponseCode, nodefault};
	__property AnsiString ResponseText = {read=GetResponseText};
	__property TInHTTPResponse* Response = {read=GetResponseHeaders};
	__property Inuri::TInURI* URL = {read=FURI};
	__property int AuthRetries = {read=FAuthRetries, write=FAuthRetries, nodefault};
	__property int AuthProxyRetries = {read=FAuthProxyRetries, write=FAuthProxyRetries, nodefault};
	__property int MaxAuthRetries = {read=FMaxAuthRetries, write=FMaxAuthRetries, default=3};
	__property bool AllowCookies = {read=FAllowCookies, write=SetAllowCookies, nodefault};
	__property bool HandleRedirects = {read=FHandleRedirects, write=FHandleRedirects, default=0};
	__property TInHTTPProtocolVersion ProtocolVersion = {read=FProtocolVersion, write=FProtocolVersion, default=1};
	__property int RedirectMaximum = {read=FRedirectMax, write=FRedirectMax, default=15};
	__property int MaxHeaderLines = {read=FMaxHeaderLines, write=FMaxHeaderLines, default=255};
	__property Inhttpheaderinfo::TIdProxyConnectionInfo* ProxyParams = {read=FProxyParameters, write=FProxyParameters};
	__property TInHTTPRequest* Request = {read=GetRequestHeaders, write=SetRequestHeaders};
	__property TInHTTPOptions HTTPOptions = {read=FOptions, write=FOptions, nodefault};
	__property TInHTTPOnRedirectEvent OnRedirect = {read=FOnRedirect, write=FOnRedirect};
	__property TIdOnSelectAuthorization OnSelectAuthorization = {read=FOnSelectAuthorization, write=FOnSelectAuthorization};
	__property TIdOnSelectAuthorization OnSelectProxyAuthorization = {read=FOnSelectProxyAuthorization, write=FOnSelectProxyAuthorization};
	__property TIdOnAuthorization OnAuthorization = {read=FOnAuthorization, write=FOnAuthorization};
	__property TIdOnAuthorization OnProxyAuthorization = {read=FOnProxyAuthorization, write=FOnProxyAuthorization};
	__property Incookiemanager::TInCookieManager* CookieManager = {read=FCookieManager, write=SetCookieManager};
	__property Inauthenticationmanager::TInAuthenticationManager* AuthenticationManager = {read=FAuthenticationManager, write=SetAuthenticationManager};
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TIdCustomHTTP(Classes::TComponent* AOwner)/* overload */ : Intcpclient::TInTCPClientCustom(AOwner) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TInHTTPResponse : public Inhttpheaderinfo::TIdResponseHeaderInfo 
{
	typedef Inhttpheaderinfo::TIdResponseHeaderInfo inherited;
	
protected:
	TIdCustomHTTP* FHTTP;
	int FResponseCode;
	AnsiString FResponseText;
	bool FKeepAlive;
	Classes::TStream* FContentStream;
	TInHTTPProtocolVersion FResponseVersion;
	bool __fastcall GetKeepAlive(void);
	int __fastcall GetResponseCode(void);
	
public:
	__fastcall virtual TInHTTPResponse(TIdCustomHTTP* AParent);
	__property bool KeepAlive = {read=GetKeepAlive, write=FKeepAlive, nodefault};
	__property AnsiString ResponseText = {read=FResponseText, write=FResponseText};
	__property int ResponseCode = {read=GetResponseCode, write=FResponseCode, nodefault};
	__property TInHTTPProtocolVersion ResponseVersion = {read=FResponseVersion, write=FResponseVersion, nodefault};
	__property Classes::TStream* ContentStream = {read=FContentStream, write=FContentStream};
public:
	#pragma option push -w-inl
	/* TIdResponseHeaderInfo.Destroy */ inline __fastcall virtual ~TInHTTPResponse(void) { }
	#pragma option pop
	
};


class DELPHICLASS TInHTTP;
class PASCALIMPLEMENTATION TInHTTP : public TIdCustomHTTP 
{
	typedef TIdCustomHTTP inherited;
	
__published:
	__property AuthRetries ;
	__property AuthProxyRetries ;
	__property MaxAuthRetries  = {default=3};
	__property AllowCookies ;
	__property HandleRedirects  = {default=0};
	__property ProtocolVersion  = {default=1};
	__property RedirectMaximum  = {default=15};
	__property ProxyParams ;
	__property Request ;
	__property HTTPOptions ;
	__property OnRedirect ;
	__property OnSelectAuthorization ;
	__property OnSelectProxyAuthorization ;
	__property OnAuthorization ;
	__property OnProxyAuthorization ;
	__property CookieManager ;
	__property Compressor ;
public:
	#pragma option push -w-inl
	/* TIdCustomHTTP.Destroy */ inline __fastcall virtual ~TInHTTP(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TInHTTP(Classes::TComponent* AOwner)/* overload */ : TIdCustomHTTP(AOwner) { }
	#pragma option pop
	
};


class DELPHICLASS EIdUnknownProtocol;
class PASCALIMPLEMENTATION EIdUnknownProtocol : public Inexception::EInException 
{
	typedef Inexception::EInException inherited;
	
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EIdUnknownProtocol(AnsiString AMsg)/* overload */ : Inexception::EInException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdUnknownProtocol(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Inexception::EInException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdUnknownProtocol(int Ident)/* overload */ : Inexception::EInException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdUnknownProtocol(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Inexception::EInException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdUnknownProtocol(const AnsiString Msg, int AHelpContext) : Inexception::EInException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdUnknownProtocol(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Inexception::EInException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdUnknownProtocol(int Ident, int AHelpContext)/* overload */ : Inexception::EInException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdUnknownProtocol(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Inexception::EInException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdUnknownProtocol(void) { }
	#pragma option pop
	
};


class DELPHICLASS EInHTTPProtocolException;
class PASCALIMPLEMENTATION EInHTTPProtocolException : public Inreplyrfc::EInReplyRFCError 
{
	typedef Inreplyrfc::EInReplyRFCError inherited;
	
protected:
	AnsiString FErrorMessage;
	
public:
	__fastcall virtual EInHTTPProtocolException(const int anErrCode, const AnsiString asReplyMessage, const AnsiString asErrorMessage);
	__property AnsiString ErrorMessage = {read=FErrorMessage};
public:
	#pragma option push -w-inl
	/* EInExceptionBase.Create */ inline __fastcall virtual EInHTTPProtocolException(AnsiString AMsg)/* overload */ : Inreplyrfc::EInReplyRFCError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EInHTTPProtocolException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Inreplyrfc::EInReplyRFCError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EInHTTPProtocolException(int Ident)/* overload */ : Inreplyrfc::EInReplyRFCError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EInHTTPProtocolException(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Inreplyrfc::EInReplyRFCError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EInHTTPProtocolException(const AnsiString Msg, int AHelpContext) : Inreplyrfc::EInReplyRFCError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EInHTTPProtocolException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Inreplyrfc::EInReplyRFCError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EInHTTPProtocolException(int Ident, int AHelpContext)/* overload */ : Inreplyrfc::EInReplyRFCError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EInHTTPProtocolException(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Inreplyrfc::EInReplyRFCError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EInHTTPProtocolException(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
#define Id_TInHTTP_ProtocolVersion (TInHTTPProtocolVersion)(1)
static const Shortint Id_TInHTTP_RedirectMax = 0xf;
static const Byte Id_TInHTTP_MaxHeaderLines = 0xff;
static const bool Id_TInHTTP_HandleRedirects = false;
static const Shortint Id_TInHTTP_MaxAuthRetries = 0x3;

}	/* namespace Inhttp */
using namespace Inhttp;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Inhttp
